import { Button, Form, Input, Radio, Select } from 'antd';
import { Uploader } from '~/components/uploader';
import { EnvironmentOutlined, UploadOutlined } from '@ant-design/icons';
import './index.scss';

const BaseInfo = () => {
  return (
    <div className='base-info'>
      <div className='base-info-header'>基本信息：</div>
      <div className='base-info-form'>
        <Form labelCol={{ span: 2 }} wrapperCol={{ span: 7 }}>
          <Form.Item label='机构主图'>
            <Uploader fileUpload listType='picture-card'>
              <UploadOutlined />
            </Uploader>
          </Form.Item>
          <Form.Item label='机构副图'>
            <Uploader fileUpload listType='picture-card'>
              <UploadOutlined />
            </Uploader>
          </Form.Item>
          <Form.Item label='机构视频'>
            <Uploader fileUpload listType='text'>
              <Button icon={<UploadOutlined />} type='primary'>
                上传视频
              </Button>
            </Uploader>
          </Form.Item>
          <Form.Item label='机构名称'>
            <Input placeholder='请输入机构名称' />
          </Form.Item>
          <Form.Item label='机构地区'>
            <Button icon={<EnvironmentOutlined />} type='primary'></Button>
          </Form.Item>
          <Form.Item label='考点机构'>
            <Radio.Group>
              <Radio value={1}>是</Radio>
              <Radio value={0}>否</Radio>
            </Radio.Group>
          </Form.Item>
          <Form.Item label='机构规模'>
            <Select placeholder='请选择机构规模'>
              <Select.Option>2-4名</Select.Option>
              <Select.Option>4-6名</Select.Option>
              <Select.Option>6-8名</Select.Option>
              <Select.Option>10名以上</Select.Option>
            </Select>
          </Form.Item>
          <Form.Item label='机构描述'>
            <Input.TextArea placeholder='请选择机构描述' />
          </Form.Item>
        </Form>
      </div>
    </div>
  );
};
export default BaseInfo;
